﻿var addMultipleStrata = {
    strata: [],
    inPercent: $("#InPercent").val() == "True",
    context: $(".v-addMultipleStrata"),
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-quotasTable", this.context).a4datatable({
            style: "compact",
            serverSide: false,            
            data: addMultipleStrata.strata,
            columns: [
                { "Name": "Index", "Title": "#", "Data": null, "Index": true },
                { "Name": "Criterion", "Data": "Criterion", "Title": resources.Criterion },
                { "Name": "Label", "Data": "Label", "Title": resources.Label }
            ],
            toolBarItems: [
                { "Action": "deleteAll", "Label": resources.DeleteAll, "DisplayMode": dataTables.itemDisplayMode.nonSelected },
                { "Action": "delete", "Label": resources.Delete }
            ],
            toolBarClick: function (event, data) {
                switch (data.action) {
                    case "deleteAll":
                        addMultipleStrata.strata = [];
                        addMultipleStrata.datatable.a4datatable("option", "data", addMultipleStrata.strata);
                        break;
                    case "delete":
                        addMultipleStrata.deleteStrata(_.pluck(data.rows, "Index"));
                        break;
                }
            },
            contextMenuItems: [
                    { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuClick: function (event, data) {
                if (data.action == "delete") {
                    addMultipleStrata.deleteStrata([data.row.Index]);
                }
            }
        });
    },
    deleteStrata: function (indexes) {
        _.each(indexes, function (index) {
            addMultipleStrata.strata[index - 1] = null;
        });

        addMultipleStrata.strata = _.compact(addMultipleStrata.strata);

        addMultipleStrata.datatable.a4datatable("option", "data", addMultipleStrata.strata);
    },
    bindEvents: function () {
        this.context.on("click", ".h-generateStrata", function () {
            var basicExpression;
            var advancedExpression;

            if ($(".h-criterionType:checked", addMultipleStrata.context).val() == "basic") {
                basicExpression = criterionExpressionEditor.getExpression();
                criterionExpressionEditor.reinitialize();
            }
            else {
                advancedExpression = $(".v-advancedExpression", addMultipleStrata.context).val();
            }            

            a4.callServerMethod(a4.getSurveyAction("GenerateMultipleStrata", "Quotas"), { basicExpression: basicExpression, advancedExpression: advancedExpression }, function (result) {
                if (result) {
                    addMultipleStrata.strata = _.uniq(_.union(addMultipleStrata.strata, result), false, function (strata) { return strata.Criterion });
                    addMultipleStrata.datatable.a4datatable("option", "data", addMultipleStrata.strata);
                }
            });
        });

        this.context.on("click", "#submit1", function () {            
            a4.callServerMethod(a4.getSurveyAction("InsertMultipleStrata", "Quotas"), { serializedStrata: JSON.stringify(addMultipleStrata.strata) }, function (result) {
                a4.parent().quotas.refreshContent(true);
                return modalDialog.close();
            });
        });

        this.context.on("change", ".h-criterionType", function () {
            $(".v-basicExpressionPanel", addMultipleStrata.context).toggle($(this).val() == "basic");
            $(".v-advancedExpressionPanel", addMultipleStrata.context).toggle($(this).val() == "advanced");
        });
    }
}

$(document).ready(function () {
    if (addMultipleStrata.context.length > 0) {
        addMultipleStrata.initializeDataTable();
        addMultipleStrata.bindEvents();
    }
});